//
//  MCPFetchSpecification.h
//  MCFoundation
//
//  Created by Alykhan Jetha on Fri Jul 04 2003.
//  Copyright (c) 2003 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCPDefinitionObject.h"

@class BDQualifier, MCPObjectContext, BDSortOrdering;

@interface MCPFetchSpecification : MCPDefinitionObject {

	BDQualifier						*qualifier;
	
	NSMutableArray					*sortOrderings;
	
	unsigned int					fetchLimit;
	unsigned int					currentBatch;
	unsigned int					totalBatches;
	unsigned int					batchRemainder;
	
	BOOL							wantsDistinct;
	
	long							resultCount;
	long							allObjectsCount;
	BOOL							didExecute;
	
	MCPObjectContext				*contextNR;		// not retained

	NSString						*entityName;
	NSString						*name;
	NSCalendarDate					*fetchCountDate;  // in case the fetch result it too old ...
	
	id								applicableParentObject; // set the parent on the fetched object -- so they can get to root ...
	
	NSArray							*propertyListKeyPaths;

    NSArray*   initialAttributes;
}

- (NSString *)entityName;
- (void)setEntityName:(NSString *)aName;

- (NSString *)name;
- (void)setName:(NSString *)aName;

- (void)setObjectContext:(MCPObjectContext *)conn;
- (MCPObjectContext *)objectContext;

- (void)setApplicableParentObject:(id)aParentObj;
- (id)applicableParentObject;

- (NSArray *)initialAttributes;
- (void)setInitialAttributes:(NSArray *)anInitialAttributes;

- (void)setFetchLimit:(unsigned int)trim;
- (unsigned int)fetchLimit;

// default is NO
- (void)setWantsDistinct:(BOOL)flag;
- (BOOL)wantsDistinct;

- (BDQualifier *)qualifier;
- (void)setQualifier:(BDQualifier *)qual;

- (void)setSortOrderings:(NSArray *)orderings;
- (NSArray *)sortOrderings;
- (void)addToSortOrderings:(BDSortOrdering *)order;
- (void)clearSortOrderings;
- (BOOL)hasSortOrderings;

- (void)setPropertyListKeyPaths:(NSArray *)array;
- (NSArray *)propertyListKeyPaths;
- (BOOL)hasPropertyListKeyPaths;

- (long)fetchResultsCount;
- (void)setFetchResultsCount: (long)count; // IF you are hacking a fetch spec, you can use this method to set it up - otherwise do not set this, it gets done internally
- (long)resultCount;

- (long)fetchAllObjectsCount;
- (long)allObjectsCount;

- (void)calculateBatchCount;

- (unsigned int)totalBatches;
- (unsigned int)currentBatchNumber;
- (void)incrementBatchNumber;
- (void)decrementBatchNumber;


- (NSMutableArray *)fetchObjects;
- (NSMutableArray *)fetchObjectsForBatch:(unsigned int)batchNumber;
- (NSMutableArray *)fetchObjectsForNextBatch;
- (NSMutableArray *)fetchObjectsForPreviousBatch;

/*
 Applies the property list key paths to the objects to return a plist (tree)
 Returns nil if next/prev batch cannot be fetched
 */
- (NSArray *)fetchPropertyLists;
- (NSArray *)fetchPropertyListsForNextBatch;
- (NSArray *)fetchPropertyListsForPreviousBatch;

- (BOOL)canFetchObjects;
- (BOOL)canFetchNextBatch;
- (BOOL)canFetchPreviousBatch;

- (void)reset;

@end
